<?php
/**
 * Author box features
 *
 * Author: Gian MR - http://www.gianmr.com
 *
 * @since 1.0.0
 * @package Idblog Core
 */

/* Exit if accessed directly */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! function_exists( 'idblog_core_author_box' ) ) {
	/**
	 * Adding the author box to the end of your single post
	 *
	 * @param string $autbox HTML author box.
	 * @since 1.0.0
	 * @return void
	 */
	function idblog_core_author_box( $autbox = null ) {
		// Displaying only in single, archive and author page.
		if ( is_single() || is_author() || is_archive() ) {

			$idblg_authox = get_option( 'idblg_autbox' );

			if ( isset( $idblg_authox['enable_autbox'] ) && ! empty( $idblg_authox['enable_autbox'] ) ) {
				// option, section, default.
				$option = $idblg_authox['enable_autbox'];
			} else {
				$option = 'on';
			}

			if ( 'on' === $option ) {

				global $post;
				$author_id = $post->post_author;

				// hide the author box if no description is provided.
				if ( ! empty( get_the_author_meta( 'description' ) ) ) {

					$autbox .= '<div class="gmr-box-content gmr-authorbox clearfix">';

						// author box gravatar.
						$autbox .= '<div class="gmr-ab-gravatar">';
						$autbox .= get_avatar( get_the_author_meta( 'user_email', $author_id ), '100' );
						$autbox .= '</div>';

						// author box name.
						$autbox .= '<div class="gmr-ab-content">';

							$autbox .= '<div class="gmr-ab-authorname">';

								$autbox .= '<span class="uname">';
								$autbox .= '<a href="' . get_author_posts_url( $author_id ) . '">' . get_the_author_meta( 'display_name', $author_id ) . '</a>';
								$autbox .= '</span>';

					if ( is_single() ) {
						// author website on single.
						if ( ! empty( get_the_author_meta( 'user_url' ) ) ) {
							$autbox .= '<span class="gmr-ab-web">';
							$autbox .= ' - <a href="' . get_the_author_meta( 'user_url', $author_id ) . '" target="_self" rel="nofollow">' . get_the_author_meta( 'user_url', $author_id ) . '</a>';
							$autbox .= '</span>';
						}
					}

					if ( is_author() || is_archive() ) {
						// force show author website on author.php or archive.php.
						if ( ! empty( get_the_author_meta( 'user_url' ) ) ) {
							$autbox .= '<span class="gmr-ab-web">';
							$autbox .= ' - <a href="' . get_the_author_meta( 'user_url', $author_id ) . '" target="_self" rel="nofollow">' . get_the_author_meta( 'user_url', $author_id ) . '</a>';
							$autbox .= '</span>';
						}
					}

							$autbox .= '</div>';

							// author box description.
							$autbox .= '<div class="gmr-ab-desc">';
							$autbox .= '<div class="vcard author">';
							$autbox .= '<span class="fn">';
							$autbox .= get_the_author_meta( 'description', $author_id );
							$autbox .= '</span>';
							$autbox .= '</div>';
							$autbox .= '</div>';

						$autbox .= '</div>'; // end gmr-ab-content.

					$autbox .= '</div>'; // end gmr-authorbox-wrap.
				}
			}
		}
		echo $autbox; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
	}
}
add_action( 'idblog_core_author_box', 'idblog_core_author_box', 10 );
