<?php
/**
 * Remove no needed script and faster theme
 *
 * Author: Gian MR - http://www.gianmr.com
 *
 * @since 1.0.0
 * @package Idblog Core
 */

/* Exit if accessed directly */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Disable the emoji's
 */
function idblog_disable_emojis() {
	$idblg_other = get_option( 'idblg_other' );

	if ( isset( $idblg_other['other_remove_emoji_script'] ) && ! empty( $idblg_other['other_remove_emoji_script'] ) ) {
		// option, section, default.
		$option = $idblg_other['other_remove_emoji_script'];
	} else {
		$option = 'off';
	}

	if ( 'on' === $option ) {
		remove_action( 'wp_head', 'print_emoji_detection_script', 7 );
		remove_action( 'admin_print_scripts', 'print_emoji_detection_script' );
		remove_action( 'wp_print_styles', 'print_emoji_styles' );
		remove_action( 'admin_print_styles', 'print_emoji_styles' );
		remove_filter( 'the_content_feed', 'wp_staticize_emoji' );
		remove_filter( 'comment_text_rss', 'wp_staticize_emoji' );
		remove_filter( 'wp_mail', 'wp_staticize_emoji_for_email' );
		add_filter( 'tiny_mce_plugins', 'idblog_disable_emojis_tinymce' );
		add_filter( 'wp_resource_hints', 'idblog_disable_emojis_remove_dns_prefetch', 10, 2 );
	}
}
add_action( 'init', 'idblog_disable_emojis' );

/**
 * Filter function used to remove the tinymce emoji plugin.
 *
 * @param array $plugins Plugins.
 * @return array Difference betwen the two arrays
 */
function idblog_disable_emojis_tinymce( $plugins ) {
	if ( is_array( $plugins ) ) {
		return array_diff( $plugins, array( 'wpemoji' ) );
	} else {
		return array();
	}
}

/**
 * Remove emoji CDN hostname from DNS prefetching hints.
 *
 * @param  array  $urls          URLs to print for resource hints.
 * @param  string $relation_type The relation type the URLs are printed for.
 * @return array                 Difference betwen the two arrays.
 */
function idblog_disable_emojis_remove_dns_prefetch( $urls, $relation_type ) {
	if ( 'dns-prefetch' === $relation_type ) {
		/** This filter is documented in wp-includes/formatting.php */
		$emoji_svg_url = apply_filters( 'emoji_svg_url', 'https://s.w.org/images/core/emoji/2/svg/' );

		$urls = array_diff( $urls, array( $emoji_svg_url ) );
	}

	return $urls;
}

/**
 * Disable embeds on init.
 *
 * - Removes the needed query vars.
 * - Disables oEmbed discovery.
 * - Completely removes the related JavaScript.
 *
 * @since 1.0.0
 */
function idblog_core_disable_embeds_init() {
	$idblg_other = get_option( 'idblg_other' );

	if ( isset( $idblg_other['other_wp_head_tag'] ) && ! empty( $idblg_other['other_wp_head_tag'] ) ) {
		// option, section, default.
		$option_head = $idblg_other['other_wp_head_tag'];
	} else {
		$option_head = 'off';
	}

	if ( 'on' === $option_head ) {
		remove_action( 'wp_head', 'rest_output_link_wp_head', 10 );
		// removes EditURI/RSD (Really Simple Discovery) link.
		remove_action( 'wp_head', 'rsd_link' );
		// removes wlwmanifest (Windows Live Writer) link.
		remove_action( 'wp_head', 'wlwmanifest_link' );
		// removes meta name generator.
		remove_action( 'wp_head', 'wp_generator' );
		// removes shortlink.
		remove_action( 'wp_head', 'wp_shortlink_wp_head' );
		// removes feed links.
		remove_action( 'wp_head', 'feed_links', 2 );
		// removes comments feed.
		remove_action( 'wp_head', 'feed_links_extra', 3 );
		remove_action( 'wp_head', 'adjacent_posts_rel_link_wp_head' );
	}
}
add_action( 'init', 'idblog_core_disable_embeds_init', 9999 );
