<?php
/**
 * WordPress settings API
 *
 * Author: Gian MR - http://www.gianmr.com
 *
 * @since 1.0.0
 * @package Idblog Core
 */

/* Exit if accessed directly */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Idblog_Core_Settings_API' ) ) :
	/**
	 * Class.
	 */
	class Idblog_Core_Settings_API {

		/**
		 * Variable Setting API
		 *
		 * @var $settings_api Setting API.
		 */
		private $settings_api;

		/**
		 * Construct
		 */
		public function __construct() {
			$this->settings_api = new WeDevs_Settings_API;

			add_action( 'admin_init', array( $this, 'admin_init' ) );
			add_action( 'admin_menu', array( $this, 'admin_menu' ) );
		}

		/**
		 * Admin Init
		 */
		public function admin_init() {

			// set the settings.
			$this->settings_api->set_sections( $this->get_settings_sections() );
			$this->settings_api->set_fields( $this->get_settings_fields() );

			// initialize settings.
			$this->settings_api->admin_init();
		}

		/**
		 * Admin Menu
		 */
		public function admin_menu() {
			add_options_page( 'Idblog Core', 'Idblog Core', 'manage_options', 'idblog-core-settings', array( $this, 'plugin_page' ) );
		}

		/**
		 * Get Settings Sections
		 */
		public function get_settings_sections() {
			$sections = array(
				array(
					'id'    => 'idblg_autbox',
					'title' => __( 'Author Box', 'idblog-core' ),
				),
				array(
					'id'    => 'idblg_relpost',
					'title' => __( 'Related Post', 'idblog-core' ),
				),
				array(
					'id'    => 'idblg_breadcrumbs',
					'title' => __( 'Breadcrumbs', 'idblog-core' ),
				),
				array(
					'id'    => 'idblg_ads',
					'title' => __( 'Ads', 'idblog-core' ),
				),
				array(
					'id'    => 'idblg_social',
					'title' => __( 'Social', 'idblog-core' ),
				),
				array(
					'id'    => 'idblg_other',
					'title' => __( 'Other', 'idblog-core' ),
				),
				array(
					'id'    => 'idblg_amp',
					'title' => __( 'AMP (New)', 'idblog-core' ),
				),
			);
			return $sections;
		}

		/**
		 * Returns all the settings fields
		 *
		 * @return array settings fields
		 */
		public function get_settings_fields() {
			$settings_fields = array(
				'idblg_autbox'      => array(
					array(
						'name'    => 'enable_autbox',
						'label'   => __( 'Enable Author Box', 'idblog-core' ),
						'desc'    => __( 'Check this if you want enable author box in single post.', 'idblog-core' ),
						'type'    => 'checkbox',
						'default' => 'on',
					),
					array(
						'name'    => 'uname_color',
						'label'   => __( 'Username Color', 'idblog-core' ),
						'type'    => 'color',
						'default' => '',
					),
					array(
						'name'    => 'desc_color',
						'label'   => __( 'Description Color', 'idblog-core' ),
						'type'    => 'color',
						'default' => '',
					),
					array(
						'name'    => 'web_color',
						'label'   => __( 'Website Color', 'idblog-core' ),
						'type'    => 'color',
						'default' => '',
					),
					array(
						'name'  => '',
						'label' => __( 'Note', 'idblog-core' ),
						'desc'  => __( 'If you want add in your own place, you can using this action: <strong>do_action( \'idblog_core_author_box\' );</strong> or you can remove action and add your own function.', 'idblog-core' ),
						'type'  => 'html',
					),
				),
				'idblg_relpost'     => array(
					array(
						'name'    => 'enable_relpost',
						'label'   => __( 'Enable related post', 'idblog-core' ),
						'desc'    => __( 'Check this if you want enable related post in single post.', 'idblog-core' ),
						'type'    => 'checkbox',
						'default' => 'on',
					),
					array(
						'name'              => 'relpost_number',
						'label'             => __( 'Number post', 'salespro-core' ),
						'desc'              => __( 'How much number post want to display on related post.', 'salespro-core' ),
						'type'              => 'number',
						'default'           => '3',
						'sanitize_callback' => 'intval',
					),
					array(
						'name'    => 'relpost_taxonomy',
						'label'   => __( 'Taxonomy', 'idblog-core' ),
						'desc'    => __( 'Choice related post by tags or category', 'idblog-core' ),
						'type'    => 'radio',
						'options' => array(
							'tags'     => 'Tags',
							'category' => 'Category',
						),
						'default' => 'category',
					),
					array(
						'name'  => '',
						'label' => __( 'Note', 'idblog-core' ),
						'desc'  => __( 'This recent post support jetpack too. If you want change this related post with jetpack, just install jetpack and activated module Related Posts For Jetpack. Display using <strong>add_filter( \'the_content\', \'idblog_core_add_related_the_content\', 40 );</strong>', 'idblog-core' ),
						'type'  => 'html',
					),
				),
				'idblg_breadcrumbs' => array(
					array(
						'name'    => 'enable_breadcrumbs',
						'label'   => __( 'Enable breadcrumbs', 'idblog-core' ),
						'desc'    => __( 'Check this if you want enable breadcrumbs.', 'idblog-core' ),
						'type'    => 'checkbox',
						'default' => 'on',
					),
					array(
						'name'    => 'breadcrumbs_hometext',
						'label'   => __( 'Homepage Text', 'salespro-core' ),
						'desc'    => '',
						'type'    => 'text',
						'default' => 'Homepage',
					),
					array(
						'name'    => 'breadcrumbs_blogtext',
						'label'   => __( 'Blog Text', 'salespro-core' ),
						'desc'    => __( 'Display only if you using blog page.', 'idblog-core' ),
						'type'    => 'text',
						'default' => 'Blog',
					),
					array(
						'name'    => 'breadcrumbs_errortext',
						'label'   => __( '404 Error Text', 'salespro-core' ),
						'desc'    => '',
						'type'    => 'text',
						'default' => '404 Not found',
					),
					array(
						'name'  => '',
						'label' => __( 'Note', 'idblog-core' ),
						'desc'  => __( 'This breadcrumbs support breadcrumb navxt or yoast breadcrumb too. If you want change this breadcrumb with that plugin, just install plugin breadcrumb navxt or wordpress SEO by seo. Display using <strong>do_action( \'idblog_core_view_breadcrumbs\' );</strong>', 'idblog-core' ),
						'type'  => 'html',
					),
				),
				'idblg_ads'         => array(
					array(
						'name'  => 'ads_topbanner',
						'label' => __( 'Top Banner', 'idblog-core' ),
						'desc'  => __( 'Display ads on right side logo. You can add adsense or manual banner.', 'idblog-core' ),
						'type'  => 'textarea',
					),
					array(
						'name'  => 'ads_topbanner_aftermenu',
						'label' => __( 'Top Banner After Menu', 'idblog-core' ),
						'desc'  => __( 'Display ads after menu. You can add adsense or manual banner.', 'idblog-core' ),
						'type'  => 'textarea',
					),
					array(
						'name'  => 'ads_after_betweenpost',
						'label' => __( 'Banner Between Post', 'idblog-core' ),
						'desc'  => __( 'Display ads between post in index and archive page. You can add adsense or manual banner.', 'idblog-core' ),
						'type'  => 'textarea',
					),
					array(
						'name'    => 'ads_after_betweenpost_position',
						'label'   => '',
						'desc'    => __( 'Position', 'idblog-core' ),
						'type'    => 'select',
						'default' => '1',
						'options' => array(
							'1' => __( 'After First Post', 'idblog-core' ),
							'2' => __( 'After Second Post', 'idblog-core' ),
							'3' => __( 'After Third Post', 'idblog-core' ),
							'4' => __( 'After Fourth Post', 'idblog-core' ),
						),
					),
					array(
						'name'  => 'ads_before_content',
						'label' => __( 'Before Single Content', 'idblog-core' ),
						'desc'  => __( 'Display ads before single content. You can add adsense or manual banner.', 'idblog-core' ),
						'type'  => 'textarea',
					),
					array(
						'name'    => 'ads_before_content_position',
						'label'   => '',
						'desc'    => __( 'Position', 'idblog-core' ),
						'type'    => 'select',
						'default' => 'default',
						'options' => array(
							'default' => 'Default',
							'left'    => 'Float left',
							'right'   => 'Float right',
							'center'  => 'Center',
						),
					),
					array(
						'name'  => 'ads_after_content',
						'label' => __( 'After Single Content', 'idblog-core' ),
						'desc'  => __( 'Display ads after single content. You can add adsense or manual banner.', 'idblog-core' ),
						'type'  => 'textarea',
					),
					array(
						'name'    => 'ads_after_content_position',
						'label'   => '',
						'desc'    => __( 'Alignment', 'idblog-core' ),
						'type'    => 'select',
						'default' => 'default',
						'options' => array(
							'default' => 'Default',
							'right'   => 'Right',
							'center'  => 'Center',
						),
					),
					array(
						'name'  => 'ads_inside_content',
						'label' => __( 'Inside Single Content', 'idblog-core' ),
						'desc'  => __( 'Display ads inside paragraph single content. You can add adsense or manual banner. Ads will not display if you have less than three paragraph in your post.', 'idblog-core' ),
						'type'  => 'textarea',
					),
					array(
						'name'    => 'ads_inside_content_position',
						'label'   => '',
						'desc'    => __( 'Alignment', 'idblog-core' ),
						'type'    => 'select',
						'default' => 'default',
						'options' => array(
							'default' => 'Default',
							'right'   => 'Right',
							'center'  => 'Center',
						),
					),
					array(
						'name'  => 'ads_floatbanner_left',
						'label' => __( 'Floating Banner Left', 'idblog-core' ),
						'desc'  => __( 'Display floating banner in left side. You can add adsense or manual banner. Display only on desktop.', 'idblog-core' ),
						'type'  => 'textarea',
					),
					array(
						'name'  => 'ads_floatbanner_right',
						'label' => __( 'Floating Banner Right', 'idblog-core' ),
						'desc'  => __( 'Display floating banner in right side. You can add adsense or manual banner. Display only on desktop.', 'idblog-core' ),
						'type'  => 'textarea',
					),
					array(
						'name'  => 'ads_floatbanner_footer',
						'label' => __( 'Floating Banner Footer', 'idblog-core' ),
						'desc'  => __( 'Display floating banner in footer. You can add adsense or manual banner. Display only on desktop.', 'idblog-core' ),
						'type'  => 'textarea',
					),
					array(
						'name'  => 'ads_footerbanner',
						'label' => __( 'Footer Banner', 'idblog-core' ),
						'desc'  => __( 'Display banner in footer. You can add adsense or manual banner.', 'idblog-core' ),
						'type'  => 'textarea',
					),
					array(
						'name'  => '',
						'label' => __( 'Note', 'idblog-core' ),
						'desc'  => __( 'Some ad place maybe conflict with Term of Use ad provider like adsense. Please read TOS first before you insert the ads. Adsense TOS: https://www.google.com/adsense/policies. All field above support shortcode too.<br /> For anti adblock, will give overlay notification, effect will cause a drop visitors in your website.', 'idblog-core' ),
						'type'  => 'html',
					),
				),
				'idblg_social'      => array(
					array(
						'name'    => 'enable_socialshare',
						'label'   => __( 'Enable social share', 'idblog-core' ),
						'desc'    => __( 'Check this if you want enable social share in single post.', 'idblog-core' ),
						'type'    => 'checkbox',
						'default' => 'on',
					),
					array(
						'name'    => 'social_app_id_facebook',
						'label'   => __( 'Facebook App ID', 'idblog-core' ),
						'desc'    => __( 'Enter your facebook App ID here, some function require app ID, better if you fill your own, or you can using default app ID from plugin.', 'idblog-core' ),
						'type'    => 'text',
						'default' => '1703072823350490',
					),
					array(
						'name'    => 'social_username_twitter',
						'label'   => __( 'Username Twitter', 'idblog-core' ),
						'desc'    => __( 'Enter your Username Twitter Without @.', 'idblog-core' ),
						'type'    => 'text',
						'default' => 'gianmrdotcom',
					),
					array(
						'name'    => 'enable_author_username_twitter',
						'label'   => __( 'Enable opengraph', 'idblog-core' ),
						'desc'    => __( 'Check this if you want enable twitter:creator meta.', 'idblog-core' ),
						'type'    => 'checkbox',
						'default' => 'on',
					),
					array(
						'name'    => 'enable_fb_comment',
						'label'   => __( 'Enable Facebook Comment', 'idblog-core' ),
						'desc'    => __( 'Check this Facebook Comment, if you check this default comment will replace with Facebook Comment.', 'idblog-core' ),
						'type'    => 'checkbox',
						'default' => 'off',
					),
					array(
						'name'  => '',
						'label' => __( 'Note', 'idblog-core' ),
						'desc'  => __( 'This social support jetpack too. If you want change this share post with jetpack, just install jetpack and activated module Sharedaddy For Jetpack, sharedaddy will automatically replace default social share. Display using <strong>add_filter( \'the_content\', \'idblog_core_add_share_the_content\', 30 );</strong>. If you activated opengraph, opengraph from jetpack will disappear. So if you want using jetpack open graph, you can disable this opengraph. If you using another opengraph plugin, please disable opengraph. Do not using opengraph plugin more then one. Opengraph display using <strong>add_action( \'wp_head\', \'idblog_opengraph_meta_tags\', 1 );</strong>', 'idblog-core' ),
						'type'  => 'html',
					),
				),
				'idblg_other'       => array(
					array(
						'name'  => 'other_fbpixel_id',
						'label' => __( 'Facebook Pixel ID', 'idblog-core' ),
						'desc'  => __( 'If you want adding Facebook Conversion Pixel code to WordPress sites, enter your facebook pixel ID here or you can add complate code via Head Script.', 'idblog-core' ),
						'type'  => 'text',
					),
					array(
						'name'  => 'other_analytics_code',
						'label' => __( 'Google Analytics Code', 'idblog-core' ),
						'desc'  => __( 'Enter your Google Analytics code (Ex: UA-XXXXX-X) or you can add complate code via Footer Script.', 'idblog-core' ),
						'type'  => 'text',
					),
					array(
						'name'  => 'other_head_script',
						'label' => __( 'Head script', 'idblog-core' ),
						'desc'  => __( 'These scripts will be printed in the <code>&lt;head&gt;</code> section.', 'idblog-core' ),
						'type'  => 'textarea',
					),
					array(
						'name'  => 'other_footer_script',
						'label' => __( 'Footer script', 'idblog-core' ),
						'desc'  => __( 'These scripts will be printed above the <code>&lt;/body&gt;</code> tag.', 'idblog-core' ),
						'type'  => 'textarea',
					),
					array(
						'name'    => 'other_remove_emoji_script',
						'label'   => __( 'Remove Emoji Script', 'idblog-core' ),
						'desc'    => __( 'Check this if you want remove emoji script from <code>&lt;head&gt;</code> section. This can improve your web performance.', 'idblog-core' ),
						'type'    => 'checkbox',
						'default' => 'off',
					),
					array(
						'name'    => 'other_wp_head_tag',
						'label'   => __( 'Remove WP Head Meta Tag', 'idblog-core' ),
						'desc'    => __( 'Check this if you want remove wp head meta tag, if this conflict with some plugin please do not activated. This option can remove wp meta tag generator, rds, wlwmanifest, feed links, shortlink, comments feed so your head tag look simple and hope can fast your index.', 'idblog-core' ),
						'type'    => 'checkbox',
						'default' => 'off',
					),
					array(
						'name'    => 'other_remove_data_when_uninstall',
						'label'   => __( 'Remove data uninstaller', 'idblog-core' ),
						'desc'    => __( 'Check this if you want remove data from database when plugin is uninstall.', 'idblog-core' ),
						'type'    => 'checkbox',
						'default' => 'off',
					),
				),

				'idblg_amp'         => array(
					array(
						'name'  => 'amp_head_script',
						'label' => __( 'AMP Head Script.', 'idblog-core' ),
						'desc'  => __( 'You can insert amp page level adsense here or other amp script. Learn more here: https://amp.dev/documentation/components/amp-ad/. These scripts will be printed in the <code>&lt;head&gt;</code> section.', 'idblog-core' ),
						'type'  => 'textarea',
					),
					array(
						'name'  => 'amp_footer_script',
						'label' => __( 'AMP Footer Script.', 'idblog-core' ),
						'desc'  => __( 'You can insert amp script in footer before &lt;/body&gt;.', 'idblog-core' ),
						'type'  => 'textarea',
					),
					array(
						'name'  => 'amp_ads_topbanner',
						'label' => __( 'Top Banner After Logo (AMP page)', 'idblog-core' ),
						'desc'  => __( 'Display amp ads after logo. Learn more here: https://amp.dev/documentation/components/amp-ad/.', 'idblog-core' ),
						'type'  => 'textarea',
					),
					array(
						'name'  => 'amp_ads_topbanner_aftermenu',
						'label' => __( 'Top Banner After Menu (AMP page)', 'idblog-core' ),
						'desc'  => __( 'Display amp ads after menu. Learn more here: https://amp.dev/documentation/components/amp-ad/.', 'idblog-core' ),
						'type'  => 'textarea',
					),
					array(
						'name'  => 'amp_ads_after_betweenpost',
						'label' => __( 'Banner Between Post (AMP page)', 'idblog-core' ),
						'desc'  => __( 'Display amp ads between post in index and archive page. Learn more here: https://amp.dev/documentation/components/amp-ad/.', 'idblog-core' ),
						'type'  => 'textarea',
					),
					array(
						'name'  => 'amp_ads_before_content',
						'label' => __( 'Before Single Content (AMP Page)', 'idblog-core' ),
						'desc'  => __( 'Display amp ads before single content. Learn more here: https://amp.dev/documentation/components/amp-ad/.', 'idblog-core' ),
						'type'  => 'textarea',
					),
					array(
						'name'  => 'amp_ads_after_content',
						'label' => __( 'After Single Content (AMP Page)', 'idblog-core' ),
						'desc'  => __( 'Display amp ads after single content. Learn more here: https://amp.dev/documentation/components/amp-ad/.', 'idblog-core' ),
						'type'  => 'textarea',
					),
					array(
						'name'  => 'amp_ads_inside_content',
						'label' => __( 'Inside Single Content', 'idblog-core' ),
						'desc'  => __( 'Display amp ads inside paragraph single content. Learn more here: https://amp.dev/documentation/components/amp-ad/. Ads will not display if you have less than three paragraph in your post.', 'idblog-core' ),
						'type'  => 'textarea',
					),
					array(
						'name'  => '',
						'label' => __( 'Note', 'idblog-core' ),
						'desc'  => __( 'This options only effect in AMP page, for enable amp you must install recommended plugin AMP plugin https://wordpress.org/plugins/amp/', 'idblog-core' ),
						'type'  => 'html',
					),
				),
			);

			return $settings_fields;
		}

		/**
		 * Plugin page.
		 */
		public function plugin_page() {
			echo '<div class="wrap">';

			$this->settings_api->show_navigation();
			$this->settings_api->show_forms();

			echo '</div>';
		}

		/**
		 * Get all the pages
		 *
		 * @return array page names with key value pairs
		 */
		public function get_pages() {
			$pages         = get_pages();
			$pages_options = array();
			if ( $pages ) {
				foreach ( $pages as $page ) {
					$pages_options[ $page->ID ] = $page->post_title;
				}
			}

			return $pages_options;
		}

	}

endif;

new Idblog_Core_Settings_API();
