<?php
/**
 * Uninstall Idblog Core plugin and delete all options from database
 *
 * @package Idblog Core
 */

/* Exit if accessed directly */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	exit();
}

$idblg_other = get_option( 'idblg_other' );

if ( isset( $idblg_other['other_remove_data_when_uninstall'] ) && ! empty( $idblg_other['other_remove_data_when_uninstall'] ) ) {
	// option, section, default.
	$option = $idblg_other['other_remove_data_when_uninstall'];
} else {
	$option = 'off';
}

if ( 'on' === $option ) {
	// Delete option from database.
	delete_option( 'idblg_autbox' );
	delete_option( 'idblg_relpost' );
	delete_option( 'idblg_breadcrumbs' );
	delete_option( 'idblg_ads' );
	delete_option( 'idblg_social' );
	delete_option( 'idblg_other' );
}
