<?php
/**
 * The template for displaying 404 pages (not found).
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package Superfast
 */

/* Exit if accessed directly */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

get_header( 'amp' );

?>

<div id="primary" class="content-area col-md-12">

	<main id="main" class="site-main" role="main">
		<section class="gmr-box-content error-404 not-found">

			<header class="entry-header">
				<h1 class="page-title screen-reader-text"><?php esc_html_e( 'Error 404', 'superfast' ); ?></h1>
				<h2 class="page-title" <?php superfast_itemprop_schema( 'headline' ); ?>><?php esc_html_e( 'Nothing Found', 'superfast' ); ?></h2>
			</header><!-- .entry-header -->

			<div class="page-content" <?php superfast_itemprop_schema( 'text' ); ?>>
				<p><?php esc_html_e( 'It looks like nothing was found at this location. Maybe try one of the links below or a search?', 'superfast' ); ?></p>

				<?php get_search_form(); ?>

			</div><!-- .page-content -->
		</section><!-- .error-404 -->
	</main><!-- #main -->
</div><!-- #primary -->

<?php
get_footer( 'amp' );
