<?php
/**
 * The template for displaying archive pages.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Superfast
 */

/* Exit if accessed directly */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

get_header( 'amp' );

// Blog layout options via customizer.
$blog_layout = get_theme_mod( 'gmr_blog_layout', 'gmr-default' );

?>

<div id="primary" class="content-area col-md-12 <?php echo esc_attr( $blog_layout ); ?>">

	<?php
	echo '<h1 class="page-title" ' . superfast_itemprop_schema( 'headline' ) . '>'; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
	the_archive_title();
	echo '</h1>';

	// display description archive page.
	the_archive_description( '<div class="taxonomy-description">', '</div>' );
	?>

	<main id="main" class="site-main" role="main">

	<?php
	if ( have_posts() ) {
		if ( 'gmr-masonry' === $blog_layout ) {
			echo '<div class="row masonry-container">';
		}

		/* Start the Loop */
		while ( have_posts() ) :
			the_post();

			/*
			 * Include the Post-Format-specific template for the content.
			 * If you want to override this in a child theme, then include a file
			 * called content-___.php (where ___ is the Post Format name) and that will be used instead.
			 */
			get_template_part( 'template-parts/content', get_post_format() );

			do_action( 'idblog_core_banner_between_posts' );

		endwhile;

		if ( 'gmr-masonry' === $blog_layout ) {
			echo '</div>';
		}
		echo gmr_get_pagination(); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped

	} else {
		get_template_part( 'template-parts/content', 'none' );

	}
	?>

	</main><!-- #main -->
</div><!-- #primary -->

<?php

get_footer( 'amp' );
