<?php
/**
 * The template for displaying the footer.
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Superfast
 */

/* Exit if accessed directly */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

?>
	<?php if ( ! is_page_template( 'page_builder.php' ) ) : ?>
				</div><!-- .row -->
			</div><!-- .container -->
			<div id="stop-container"></div>
		</div><!-- .gmr-content -->
	<?php endif; ?>

</div><!-- #site-container -->

<?php
global $post;

// Prevent error in 404 page.
$postid = ( isset( $post->ID ) ? get_the_ID() : null );

$footer_display = get_post_meta( $postid, '_gmr_footer_key', true );

if ( ! $footer_display || is_search() ) :
	?>
	<div id="footer-container">
		<div class="gmr-bgstripes">
			<span class="gmr-bgstripe gmr-color1"></span><span class="gmr-bgstripe gmr-color2"></span>
			<span class="gmr-bgstripe gmr-color3"></span><span class="gmr-bgstripe gmr-color4"></span>
			<span class="gmr-bgstripe gmr-color5"></span><span class="gmr-bgstripe gmr-color6"></span>
			<span class="gmr-bgstripe gmr-color7"></span><span class="gmr-bgstripe gmr-color8"></span>
			<span class="gmr-bgstripe gmr-color9"></span><span class="gmr-bgstripe gmr-color10"></span>
			<span class="gmr-bgstripe gmr-color11"></span><span class="gmr-bgstripe gmr-color12"></span>
			<span class="gmr-bgstripe gmr-color13"></span><span class="gmr-bgstripe gmr-color14"></span>
			<span class="gmr-bgstripe gmr-color15"></span><span class="gmr-bgstripe gmr-color16"></span>
			<span class="gmr-bgstripe gmr-color17"></span><span class="gmr-bgstripe gmr-color18"></span>
			<span class="gmr-bgstripe gmr-color19"></span><span class="gmr-bgstripe gmr-color20"></span>
		</div>

		<footer id="colophon" class="site-footer" role="contentinfo" <?php superfast_itemtype_schema( 'WPFooter' ); ?>>
			<div class="container">
				<div class="site-info">
				<?php
					/* Add Non AMP Version using <div id="site-version-switcher"> and id="version-switch-link" */
					$nonamp_link = amp_remove_endpoint( amp_get_current_url() );
					echo '<div class="text-center nonamp-button"><div id="site-version-switcher"><a id="version-switch-link" href="' . esc_url( $nonamp_link ) . '" class="amp-wp-canonical-link" title="' . __( 'Non AMP Version', 'superfast' ) . '" rel="noamphtml">' . __( 'Non AMP Version', 'superfast' ) . '</a></div></div>';			
				?>
				<?php
				$copyright = get_theme_mod( 'gmr_copyright' );
				if ( $copyright ) :
					// sanitize html output than convert it again using htmlspecialchars_decode.
					echo wp_kses_post( $copyright );
				else :
					?>
					<a href="<?php echo esc_url( 'https://wordpress.org/' ); ?>" title="<?php esc_html_e( 'Proudly powered by WordPress', 'superfast' ); ?>"><?php esc_html_e( 'Proudly powered by WordPress', 'superfast' ); ?></a>
					<span class="sep"> / </span>
					<a href="<?php echo esc_url( 'https://www.idtheme.com/superfast/' ); ?>" title="<?php /* translators: %s: Superfast */ printf( esc_html__( 'Theme: %s', 'superfast' ), 'Superfast' ); ?>"><?php printf( /* translators: %s: Superfast */ esc_html__( 'Theme: %s', 'superfast' ), 'Superfast' ); ?></a>
				<?php endif; ?>
				</div><!-- .site-info -->
			</div><!-- .container -->
		</footer><!-- #colophon -->

	<?php
		endif;
?>

</div><!-- #footer-container -->

<amp-sidebar id="navigationamp" layout="nodisplay" side="left">
	<?php do_action( 'gmr_the_custom_logo' ); ?>
	<button on="tap:navigationamp.close" class="close-topnavmenu-wrap"><span class="icon_close_alt2"></span></button>
	<?php
	wp_nav_menu(
		array(
			'theme_location' => 'primary',
			'container'      => 'ul',
			'menu_id'        => 'primary-menu',
			'link_before'    => '<span itemprop="name">',
			'link_after'     => '</span>',
		)
	);
	?>
	<?php
	wp_nav_menu(
		array(
			'theme_location' => 'secondary',
			'container'      => 'ul',
			'fallback_cb'    => '',
			'menu_id'        => 'primary-menu',
			'link_before'    => '<span itemprop="name">',
			'link_after'     => '</span>',
		)
	);
	?>
	<?php
	// Option remove search button.
	$setting    = 'gmr_active-searchbutton';
	$mod_search = get_theme_mod( $setting, customizer_library_get_default( $setting ) );
	if ( 0 === $mod_search ) :
		?>
		<form method="get" class="gmr-searchform searchform" action="<?php echo esc_url( home_url( '/' ) ); ?>">
			<input type="text" name="s" id="s" placeholder="<?php echo esc_html__( 'Search', 'superfast' ); ?>" />
		</form>
	<?php endif; ?>
</amp-sidebar>

<?php wp_footer(); ?>

</body>
</html>
