<?php
/**
 * Importer plugin filter.
 *
 * @link https://wordpress.org/plugins/one-click-demo-import/
 *
 * @package Superfast
 */

/* Exit if accessed directly */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! function_exists( 'superfast_ocdi_import_files' ) ) :
	/**
	 * Set one click import demo data. Plugin require is. https://wordpress.org/plugins/one-click-demo-import/
	 *
	 * @since v.1.0.0
	 * @link https://wordpress.org/plugins/one-click-demo-import/faq/
	 *
	 * @return array
	 */
	function superfast_ocdi_import_files() {
		if ( class_exists( 'WooCommerce' ) ) {
			$arr = array(
				array(
					'import_file_name'             => 'Demo Import Default Layout',
					'local_import_file'            => trailingslashit( get_template_directory() ) . 'inc/demo-data/demo-content.xml',
					'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'inc/demo-data/widgets.json',
					'local_import_customizer_file' => trailingslashit( get_template_directory() ) . 'inc/demo-data/customizer.dat',
					'import_preview_image_url'     => 'https://c1.staticflickr.com/1/762/31176126573_840fbde898_o.jpg',
					'import_notice'                => __( 'Import demo from http://demo.idtheme.com/superfast/.', 'superfast' ),
				),
				array(
					'import_file_name'             => 'Demo Import Masonry Layout',
					'local_import_file'            => trailingslashit( get_template_directory() ) . 'inc/demo-data/demo-content.xml',
					'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'inc/demo-data/widgets-masonry.json',
					'local_import_customizer_file' => trailingslashit( get_template_directory() ) . 'inc/demo-data/customizer-masonry.dat',
					'import_preview_image_url'     => 'https://c1.staticflickr.com/1/730/31985283045_18f9b79e34_o.jpg',
					'import_notice'                => __( 'Import demo from http://demo.idtheme.com/superfast-masonry/.', 'superfast' ),
				),
				array(
					'import_file_name'             => 'Demo Import Woocommerce Layout',
					'local_import_file'            => trailingslashit( get_template_directory() ) . 'inc/demo-data/demo-content-woo.xml',
					'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'inc/demo-data/widgets-woo.json',
					'local_import_customizer_file' => trailingslashit( get_template_directory() ) . 'inc/demo-data/customizer-woo.dat',
					'import_preview_image_url'     => 'https://c1.staticflickr.com/1/536/31176126143_9326bc2ec7_o.jpg',
					'import_notice'                => __( 'Import demo from http://demo.idtheme.com/superfast-woo/.', 'superfast' ),
				),
			);
		} else {
			$arr = array(
				array(
					'import_file_name'             => 'Demo Import Default Layout',
					'local_import_file'            => trailingslashit( get_template_directory() ) . 'inc/demo-data/demo-content.xml',
					'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'inc/demo-data/widgets.json',
					'local_import_customizer_file' => trailingslashit( get_template_directory() ) . 'inc/demo-data/customizer.dat',
					'import_preview_image_url'     => 'https://c1.staticflickr.com/1/762/31176126573_840fbde898_o.jpg',
					'import_notice'                => __( 'Import demo from http://demo.idtheme.com/superfast/.', 'superfast' ),
				),
				array(
					'import_file_name'             => 'Demo Import Masonry Layout',
					'local_import_file'            => trailingslashit( get_template_directory() ) . 'inc/demo-data/demo-content.xml',
					'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'inc/demo-data/widgets-masonry.json',
					'local_import_customizer_file' => trailingslashit( get_template_directory() ) . 'inc/demo-data/customizer-masonry.dat',
					'import_preview_image_url'     => 'https://c1.staticflickr.com/1/730/31985283045_18f9b79e34_o.jpg',
					'import_notice'                => __( 'Import demo from http://demo.idtheme.com/superfast-masonry/.', 'superfast' ),
				),
			);
		}
		return $arr;
	}
endif;
add_filter( 'pt-ocdi/import_files', 'superfast_ocdi_import_files' );

if ( ! function_exists( 'superfast_ocdi_after_import' ) ) :
	/**
	 * Set action after import demo data. Plugin require is. https://wordpress.org/plugins/one-click-demo-import/
	 *
	 * @since v.1.0.0
	 * @link https://wordpress.org/plugins/one-click-demo-import/faq/
	 * @param array $selected_import selection importer data.
	 *
	 * @return void
	 */
	function superfast_ocdi_after_import( $selected_import ) {

		// Menus to Import and assign - you can remove or add as many as you want.
		$top_menu = get_term_by( 'name', 'Top menus', 'nav_menu' );

		set_theme_mod(
			'nav_menu_locations',
			array(
				'primary' => $top_menu->term_id,
			)
		);

		if ( 'Demo Import Default Layout' === $selected_import['import_file_name'] ) {
			// update option post per page.
			update_option( 'posts_per_page', 7 );
		}
		if ( 'Demo Import Masonry Layout' === $selected_import['import_file_name'] ) {
			// update option post per page.
			update_option( 'posts_per_page', 6 );
		}
		if ( 'Demo Import Woocommerce Layout' === $selected_import['import_file_name'] && class_exists( 'WooCommerce' ) ) {
			// update option post per page.
			update_option( 'posts_per_page', 6 );
			// get page name.
			$homepage = get_page_by_title( 'Shop' );
			if ( $homepage ) {
				update_option( 'page_on_front', $homepage->ID );
				update_option( 'show_on_front', 'page' );
			}
			// get page name.
			$blog = get_page_by_title( 'blog' );
			if ( $blog ) {
				update_option( 'page_for_posts', $blog->ID );
			}
		}

	}
endif;
add_action( 'pt-ocdi/after_import', 'superfast_ocdi_after_import' );

if ( ! function_exists( 'superfast_change_time_of_single_ajax_call' ) ) :
	/**
	 * Change ajax call timeout
	 *
	 * @link https://github.com/awesomemotive/one-click-demo-import/blob/master/docs/import-problems.md.
	 */
	function superfast_change_time_of_single_ajax_call() {
		return 60;
	}
endif;
add_action( 'pt-ocdi/time_for_one_ajax_call', 'superfast_change_time_of_single_ajax_call' );

// disable generation of smaller images (thumbnails) during the content import.
add_filter( 'pt-ocdi/regenerate_thumbnails_in_content_import', '__return_false' );

// disable the branding notice.
add_filter( 'pt-ocdi/disable_pt_branding', '__return_true' );
