<?php
/**
 * Template part for displaying posts.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Superfast
 */

// Blog layout options via customizer.
$blog_layout = get_theme_mod( 'gmr_blog_layout', 'gmr-smallthumb' );

// Disable thumbnail options via customizer.
$thumbnail = get_theme_mod( 'gmr_active-blogthumb', 0 );

// Disable meta data options via customizer.
$metadata = get_theme_mod( 'gmr_active-metaarchive', 0 );

// Disable page navigation posts in archive options via customizer.
$pagenav = get_theme_mod( 'gmr_active-pagenavposts', 0 );

// Blog Content options via customizer.
$blog_content = get_theme_mod( 'gmr_blog_content', 'excerpt' );

// Sidebar layout options via customizer.
$sidebar_layout = get_theme_mod( 'gmr_blog_sidebar', 'sidebar' );


if ( 'gmr-masonry' === $blog_layout ) {

	// layout masonry base sidebar options.
	if ( 'fullwidth' === $sidebar_layout ) {
		$classes = array(
			'col-masonry-4',
			'item',
		);
	} else {
		$classes = array(
			'col-masonry-6',
			'item',
		);
	}
} elseif ( 'gmr-smallthumb' === $blog_layout ) {
	$classes = array(
		'gmr-smallthumb',
		'clearfix',
	);

} else {
	$classes = array(
		'clearfix',
	);
}
?>

<article id="post-<?php the_ID(); ?>" <?php post_class( $classes ); ?> <?php echo superfast_itemtype_schema( 'CreativeWork' ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>>

	<div class="gmr-box-content">

			<?php
			// Add thumnail.
			if ( 0 === $thumbnail ) :
				if ( has_post_thumbnail() ) {
					echo '<div class="content-thumbnail">';
						echo '<a href="' . esc_url( get_permalink() ) . '" itemprop="url" title="' . the_title_attribute(
							array(
								'before' => __( 'Permalink to: ', 'superfast' ),
								'after'  => '',
								'echo'   => false,
							)
						) . '" rel="bookmark">';
					if ( 'gmr-masonry' === $blog_layout ) :
						the_post_thumbnail( 'masonry-size', array( 'itemprop' => 'image' ) );

					elseif ( 'gmr-smallthumb' === $blog_layout ) :
						the_post_thumbnail( 'medium', array( 'itemprop' => 'image' ) );

					else :
						the_post_thumbnail( 'large', array( 'itemprop' => 'image' ) );

					endif; // endif.
						echo '</a>';
					echo '</div>';
				}
			endif;
			?>

		<div class="item-article">
			<header class="entry-header">
				<h2 class="entry-title" <?php echo superfast_itemprop_schema( 'headline' ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>>
					<a href="<?php the_permalink(); ?>" <?php echo superfast_itemprop_schema( 'url' ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?> title="<?php the_title_attribute( array( 'before' => __( 'Permalink to: ', 'superfast' ), 'after' => '' ) ); ?>" rel="bookmark"><?php the_title(); ?></a>
				</h2>

				<?php
				if ( 'post' === get_post_type() ) :
					if ( 0 === $metadata ) :
						?>
					<div class="entry-meta">
						<?php gmr_posted_on(); ?>
					</div><!-- .entry-meta -->
						<?php
					endif;
				endif;
				?>
			</header><!-- .entry-header -->

			<div class="entry-content" <?php echo superfast_itemprop_schema( 'text' ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>>
				<?php
				if ( 'fullcontent' === $blog_content ) :
					the_content();

				else :
					the_excerpt();

				endif;
				if ( 0 === $pagenav ) :
					wp_link_pages(
						array(
							'before'      => '<div class="page-links"><span class="page-text">' . esc_html__( 'Pages:', 'superfast' ) . '</span>',
							'after'       => '</div>',
							'link_before' => '<span class="page-link-number">',
							'link_after'  => '</span>',
						)
					);
				endif;
				?>
			</div><!-- .entry-content -->
		</div><!-- .item-article -->

	<?php if ( is_sticky() ) { ?>
		<kbd class="kbd-sticky"><?php esc_html_e( 'Sticky', 'superfast' ); ?></kbd>
	<?php } ?>

	</div><!-- .gmr-box-content -->

</article><!-- #post-## -->
